// priority: 10
let 生物强化调试 = false; // 将此设为 true 来启用日志, false 关闭
let 阶段赋予调试 = false; // 设置为 true 开启此脚本的调试日志, false 关闭

let 生物强化日志 = (消息) => {
    if (生物强化调试) {
        console.log("[生物强化调试] " + 消息);
    }
}

let 计算附魔等级 = (等级配置) => {
    if (typeof 等级配置 === "number") return 等级配置;
    if (typeof 等级配置 === "object") {
        if (等级配置.最小等级 !== undefined && 等级配置.最大等级 !== undefined) {
            let 最小 = Math.max(0, 等级配置.最小等级);
            let 最大 = Math.max(最小, 等级配置.最大等级);
            return 最小 > 最大 ? 最小 : Math.floor(Math.random() * (最大 - 最小 + 1)) + 最小;
        }
        if (等级配置.等级列表 && 等级配置.权重列表 && 等级配置.等级列表.length === 等级配置.权重列表.length && 等级配置.等级列表.length > 0) {
            let 总权重 = 0;
            等级配置.权重列表.forEach(单个权重 => 总权重 += (单个权重 > 0 ? 单个权重 : 0));
            if (总权重 <= 0) return 等级配置.等级列表[0] || 1;
            let 随机数 = Math.random() * 总权重;
            let 当前权重累加 = 0;
            for (let 索引 = 0; 索引 < 等级配置.等级列表.length; 索引++) {
                if (等级配置.权重列表[索引] > 0) {
                    当前权重累加 += 等级配置.权重列表[索引];
                    if (随机数 <= 当前权重累加) return 等级配置.等级列表[索引];
                }
            }
            for (let 索引 = 等级配置.权重列表.length - 1; 索引 >= 0; 索引--) {
                if (等级配置.权重列表[索引] > 0) return 等级配置.等级列表[索引];
            }
            return 等级配置.等级列表[0] || 1;
        }
    }
    return 1;
}

let 从物品池取随机物品 = (物品池配置数组, 池调试名) => {
    生物强化日志(`进入函数: 从物品池取随机物品, 池名: ${池调试名 || "未知池"}`);
    if (!物品池配置数组 || 物品池配置数组.length === 0) return null;

    let 总物品权重 = 0;
    let 有效物品定义们 = [];
    物品池配置数组.forEach(条目 => {
        if (条目 && typeof 条目.物品ID === "string") {
            let 当前权重 = (条目.物品权重 !== undefined && typeof 条目.物品权重 === "number" && 条目.物品权重 > 0) ? 条目.物品权重 : 1;
            总物品权重 += 当前权重;
            有效物品定义们.push({ "定义": 条目, "计算后权重": 当前权重 });
        }
    });

    if (有效物品定义们.length === 0) return null;

    let 选中物品定义 = null;
    if (总物品权重 <= 0) {
        选中物品定义 = 有效物品定义们[Math.floor(Math.random() * 有效物品定义们.length)].定义;
    } else {
        let 随机选择值 = Math.random() * 总物品权重;
        let 当前累加权重 = 0;
        for (let 带权条目 of 有效物品定义们) {
            当前累加权重 += 带权条目.计算后权重;
            if (随机选择值 < 当前累加权重) {
                选中物品定义 = 带权条目.定义;
                break;
            }
        }
        if (!选中物品定义) {
            选中物品定义 = 有效物品定义们[有效物品定义们.length - 1].定义;
        }
    }

    if (!选中物品定义 || typeof 选中物品定义.物品ID !== "string") return null;
    生物强化日志(`选中基础物品定义，物品ID: ${选中物品定义.物品ID}`);

    let 选中附魔组配置 = { "附魔列表": [] };
    if (选中物品定义.附魔方案列表 && 选中物品定义.附魔方案列表.length > 0) {
        let 总附魔组权重 = 0;
        let 有效附魔方案们 = [];
        选中物品定义.附魔方案列表.forEach(方案 => {
            if (!方案) return;
            let 当前方案权重 = (方案.选择权重 !== undefined && typeof 方案.选择权重 === "number" && 方案.选择权重 > 0) ? 方案.选择权重 : 1;
            总附魔组权重 += 当前方案权重;
            有效附魔方案们.push({ "定义": 方案, "计算后权重": 当前方案权重 });
        });

        if (有效附魔方案们.length > 0) {
            if (总附魔组权重 <= 0) {
                选中附魔组配置 = 有效附魔方案们[Math.floor(Math.random() * 有效附魔方案们.length)].定义;
            } else {
                let 随机附魔组值 = Math.random() * 总附魔组权重;
                let 当前附魔累加权重 = 0;
                for (let 带权方案 of 有效附魔方案们) {
                    当前附魔累加权重 += 带权方案.计算后权重;
                    if (随机附魔组值 < 当前附魔累加权重) {
                        选中附魔组配置 = 带权方案.定义;
                        break;
                    }
                }
                if (!选中附魔组配置) {
                    选中附魔组配置 = 有效附魔方案们[有效附魔方案们.length - 1].定义;
                }
            }
        }
    }
    if (!选中附魔组配置) 选中附魔组配置 = { "附魔列表": [] };
    生物强化日志(`选中附魔组 (选择权重 ${选中附魔组配置.选择权重 || "无或默认1"}) 用于物品 ${选中物品定义.物品ID}: ${JSON.stringify(选中附魔组配置)}`);

    let 物品ID = 选中物品定义.物品ID;
    let 物品数量 = 选中物品定义.物品数量 || 1;

    let 最终NBT = {};
    let 基础NBT数据 = 选中物品定义.基础NBT数据 || {};
    let 方案附加NBT = 选中附魔组配置.附加NBT数据 || {};

    for (let 键 in 基础NBT数据) { if (基础NBT数据.hasOwnProperty(键)) 最终NBT[键] = 基础NBT数据[键]; }
    for (let 键 in 方案附加NBT) { if (方案附加NBT.hasOwnProperty(键)) 最终NBT[键] = 方案附加NBT[键]; }
    生物强化日志(`构建物品: 标识=${物品ID}, 数量=${物品数量}, 最终NBT数据=${JSON.stringify(最终NBT)}`);

    let 物品实例 = null;
    try {
        物品实例 = Item.of(物品ID, 物品数量);
        if (Object.keys(最终NBT).length > 0) {
            if (最终NBT.display && 最终NBT.display.Name) 生物强化日志(`应用NBT中的自定义名称: ${最终NBT.display.Name}`);
            物品实例 = 物品实例.withNBT(最终NBT);
            生物强化日志(`物品 ${物品ID} 应用NBT后: ${物品实例.nbt}`);
        }
    } catch (错误对象) {
        console.error(`[生物强化错误] 创建物品或应用NBT失败: 标识=${物品ID}, NBT数据=${JSON.stringify(最终NBT)}. 错误: ${错误对象}`);
        return null;
    }

    if (选中附魔组配置.附魔列表 && 选中附魔组配置.附魔列表.length > 0) {
        选中附魔组配置.附魔列表.forEach(附魔配置 => {
            if (附魔配置 && typeof 附魔配置.附魔ID === "string" && 附魔配置.附魔等级 !== undefined) {
                let 等级 = 计算附魔等级(附魔配置.附魔等级);
                if (等级 > 0) {
                    try {
                        物品实例 = 物品实例.enchant(附魔配置.附魔ID, 等级);
                        生物强化日志(`成功附魔: ${附魔配置.附魔ID} 等级 ${等级}。物品当前附魔: ${物品实例.enchantments ? JSON.stringify(物品实例.enchantments) : "无"}`);
                    } catch (错误对象) {
                        console.error(`[生物强化错误] 附魔失败: 物品=${物品ID}, 附魔ID=${附魔配置.附魔ID}, 等级=${等级}. 错误: ${错误对象}`);
                    }
                }
            }
        });
    }
    生物强化日志(`物品 ${物品ID} 构建和附魔完成。最终物品NBT: ${物品实例 ? 物品实例.nbt : "null"}`);
    return 物品实例;
}

let 筛选带阶段玩家 = (玩家列表, 阶段名) => {
    return 玩家列表.filter(p =>
        p.stages && typeof p.stages.has === "function" && p.stages.has(阶段名)
    );
}

let 判定当前难度 = (附近玩家, sDATA) => {
    let 难度优先级 = 难度标签键名数组.slice().reverse();
    生物强化日志(`判定当前难度: 难度判断优先级: ${JSON.stringify(难度优先级)}, 实际难度阶段前缀: "${难度阶段前缀}"`);

    for (let 期望难度 of 难度优先级) {
        let 目标阶段名 = 难度阶段前缀 + 期望难度;
        if (筛选带阶段玩家(附近玩家, 目标阶段名).length > 0) {
            生物强化日志(`根据玩家阶段确定难度为: ${期望难度}`);
            return 期望难度;
        }
    }

    if (sDATA.contains("游戏难度")) {
        let 服务器设定难度 = sDATA.getString("游戏难度");
        if (难度标签键名数组.includes(服务器设定难度)) {
            生物强化日志(`使用服务器指令设定的全局游戏难度: ${服务器设定难度}`);
            return 服务器设定难度;
        }
    }
    生物强化日志(`无玩家特定阶段或有效服务器设定难度, 使用脚本定义的默认难度: ${默认难度}`);
    return 默认难度;
}

let 判定动态阶段 = (主配置, 附近玩家, sDATA) => {
    if (!主配置 || !主配置.动态阶段优先级 || !主配置.动态阶段强化效果 || 附近玩家.length === 0) return null;

    let 全局动态难度强制 = sDATA.contains("globalDynamicDifficultyForce") ? sDATA.getBoolean("globalDynamicDifficultyForce") : false;
    let 全局动态难度强制状态 = 全局动态难度强制 && (sDATA.contains("globalDynamicDifficultyForceState") ? sDATA.getBoolean("globalDynamicDifficultyForceState") : false);

    for (let 阶段名 of 主配置.动态阶段优先级) {
        for (let p of 附近玩家) {
            let pDATA = p.persistentData;
            let 玩家动态难度启用 = 全局动态难度强制 ? 全局动态难度强制状态 : (pDATA.contains("dynamicDifficultyEnabled") ? pDATA.getBoolean("dynamicDifficultyEnabled") : true);
            if (玩家动态难度启用 && 筛选带阶段玩家([p], 阶段名).length > 0) {
                生物强化日志(`确定生效动态阶段为: ${阶段名}`);
                return 阶段名;
            }
        }
    }
    return null;
}

EntityEvents.spawned(e => {
    let 目标 = e.entity;
    if (!目标 || !目标.isLiving() || 目标.isPlayer()) return;

    let 已处理标记键 = "强化已处理标识";
    if (目标.persistentData.getBoolean(已处理标记键)) return;

    let 目标ID = String(目标.type);
    生物强化日志(`处理实体: ${目标ID}`);

    let s = e.level.getServer();
    if (!s) return;
    let sDATA = s.persistentData;

    let 附近玩家 = e.level.getEntitiesWithin(目标.getBoundingBox().inflate(128)).filter(搜索到实体 => 搜索到实体.isPlayer());

    let 难度标识 = 判定当前难度(附近玩家, sDATA);
    生物强化日志(`当前难度标识: ${难度标识}`);
    let 动态阶段名 = 判定动态阶段(生物强化全局配置, 附近玩家, sDATA);
    if (动态阶段名) 生物强化日志(`当前生效动态阶段名: ${动态阶段名}`);

    let 目标白名单配置 = 生物影响白名单 ? 生物影响白名单[目标ID] : undefined;
    let 目标定制配置 = (生物定制配置 && 生物定制配置[目标ID]) ? 生物定制配置[目标ID] : undefined;
    let 目标直接修改配置 = (不使用修改器生物列表 && 不使用修改器生物列表[目标ID])
        ? 不使用修改器生物列表[目标ID]
        : undefined;
    let 是否直接修改属性 = !!目标直接修改配置;

    if (!目标白名单配置 && !目标定制配置 && !目标直接修改配置) {
        目标.persistentData.putBoolean(已处理标记键, true);
        return;
    }

    let 各属性总倍率 = {};
    for (let 属性中文名 in 属性名映射表) 各属性总倍率[属性中文名] = 1.0;

    let 全局难度属性倍率 = 难度属性定义;
    let 当前难度倍率效果 = (全局难度属性倍率 && 全局难度属性倍率[难度标识]) ? 全局难度属性倍率[难度标识] : (全局难度属性倍率 && 全局难度属性倍率[默认难度]) ? 全局难度属性倍率[默认难度] : {};

    for (let 属性中文名 in 当前难度倍率效果) {
        if (属性名映射表[属性中文名]) {
            各属性总倍率[属性中文名] *= 当前难度倍率效果[属性中文名];
        }
    }

    if (目标直接修改配置) {
        for (let 属性中文名 in 目标直接修改配置) {
            if (属性名映射表[属性中文名] && typeof 目标直接修改配置[属性中文名] === "number") {
                各属性总倍率[属性中文名] *= 目标直接修改配置[属性中文名];
            }
        }
    } else {
        if (目标白名单配置) {
            for (let 属性中文名 in 目标白名单配置) {
                if (属性名映射表[属性中文名] && typeof 目标白名单配置[属性中文名] === "number") {
                    各属性总倍率[属性中文名] *= 目标白名单配置[属性中文名];
                }
            }
        }
        if (目标定制配置 && 目标定制配置.属性列表) {
            for (let 属性中文名 in 目标定制配置.属性列表) {
                if (属性名映射表[属性中文名] && typeof 目标定制配置.属性列表[属性中文名] === "number") {
                    各属性总倍率[属性中文名] *= 目标定制配置.属性列表[属性中文名];
                }
            }
        }
    }

    if (动态阶段名 && 动态阶段强化效果 && 动态阶段强化效果[动态阶段名] && 动态阶段强化效果[动态阶段名].属性列表) {
        let 动态阶段属性倍率 = 动态阶段强化效果[动态阶段名].属性列表;
        for (let 属性中文名 in 动态阶段属性倍率) {
            if (属性名映射表[属性中文名] && typeof 动态阶段属性倍率[属性中文名] === "number") {
                各属性总倍率[属性中文名] *= 动态阶段属性倍率[属性中文名];
            }
        }
    }

    生物强化日志(`最终各属性总倍率 for ${目标ID}: ${JSON.stringify(各属性总倍率)}`);

    for (let 属性中文名 in 各属性总倍率) {
        let 属性定义 = 属性名映射表[属性中文名];
        if (!属性定义 || !属性定义.id) {
            continue;
        }
        let 映射属性ID = 属性定义.id;
        let 目标属性对象 = 目标.getAttribute(映射属性ID);
        if (!目标属性对象) {
            continue;
        }
        let 最终倍率 = 各属性总倍率[属性中文名];
        let 属性基值 = 目标属性对象.getBaseValue();
        if (最终倍率 === 1.0 && !是否直接修改属性 && Math.abs(属性基值 * 最终倍率 - 属性基值) < 0.0001) {
            continue;
        }
        if (是否直接修改属性) {
            let 新属性基值 = 属性基值 * 最终倍率;
            if (属性中文名 === "生命") {
                let 实际设定生命值 = 新属性基值 > 0 ? 新属性基值 : 1.0;
                目标属性对象.setBaseValue(实际设定生命值);
            } else {
                目标属性对象.setBaseValue(新属性基值);
            }
        } else {
            let 修饰符唯一ID串 = 属性定义.uuid;
            if (!修饰符唯一ID串) {
                continue;
            }
            let 修饰符效果值 = 最终倍率 - 1;
            if (Math.abs(修饰符效果值) < 0.0001 && 最终倍率 !== 0) {
                continue;
            }
            let 修改器名称 = `生物强化_${目标ID}_${属性中文名}`;
            let 新属性修饰符 = new $属性修改器(
                $唯一标识符.fromString(修饰符唯一ID串),
                修改器名称,
                修饰符效果值,
                $属性修改器.Operation.MULTIPLY_BASE
            );
            目标属性对象.removeModifier($唯一标识符.fromString(修饰符唯一ID串));
            目标属性对象.addPermanentModifier(新属性修饰符);
        }
    }

    if (!(sDATA.contains("mobEquipEnabled") ? sDATA.getBoolean("mobEquipEnabled") : true)) {
        目标.persistentData.putBoolean(已处理标记键, true);
        return;
    }

    let 当前装备基础概率表 = {};
    let 全局难度装备基础概率 = 难度装备基础概率;
    if (全局难度装备基础概率 && 全局难度装备基础概率[难度标识]) Object.assign(当前装备基础概率表, 全局难度装备基础概率[难度标识]);
    if (动态阶段名 && 动态阶段强化效果[动态阶段名] && 动态阶段强化效果[动态阶段名].装备基础概率) Object.assign(当前装备基础概率表, 动态阶段强化效果[动态阶段名].装备基础概率);
    if (目标定制配置 && 目标定制配置.装备基础概率) Object.assign(当前装备基础概率表, 目标定制配置.装备基础概率);
    生物强化日志(`最终装备掉落基础概率池: ${JSON.stringify(当前装备基础概率表)}`);

    for (let [槽位名, 槽位枚举] of Object.entries(槽位映射)) {
        let 槽位概率倍率 = 1.0;

        if (目标直接修改配置 && typeof 目标直接修改配置[槽位名] === "number") {
            槽位概率倍率 *= 目标直接修改配置[槽位名];
        } else if (目标白名单配置 && typeof 目标白名单配置[槽位名] === "number") {
            槽位概率倍率 *= 目标白名单配置[槽位名];
        }

        if (目标定制配置 && 目标定制配置.装备池引用 && 目标定制配置.装备池引用[槽位名] &&
            !(目标定制配置.装备基础概率 && 目标定制配置.装备基础概率[槽位名] !== undefined) &&
            槽位概率倍率 === 0) {
            槽位概率倍率 = 1.0;
        }

        let 槽位基础掉落率 = 当前装备基础概率表[槽位名] !== undefined ? 当前装备基础概率表[槽位名] : 0;
        let 槽位最终掉落率 = 槽位基础掉落率 * 槽位概率倍率;
        生物强化日志(`${槽位名} - 最终装备概率: ${槽位最终掉落率}`);

        if (槽位最终掉落率 > 0 && Math.random() < 槽位最终掉落率) {
            let 抽中护甲物品 = null;
            let 当前护甲池数组 = null;
            let 护甲池来源提示 = "";

            if (目标定制配置 && 目标定制配置.装备池引用 && 目标定制配置.装备池引用[槽位名]) {
                let 引用池名 = 目标定制配置.装备池引用[槽位名];
                护甲池来源提示 = `定制池(${难度标识}.${引用池名})`;
                if (定制实体护甲池 && 定制实体护甲池[难度标识] && 定制实体护甲池[难度标识][引用池名]) {
                    当前护甲池数组 = 定制实体护甲池[难度标识][引用池名];
                }
            }
            if (!当前护甲池数组 && 目标白名单配置 && 目标白名单配置.装备池引用 && 目标白名单配置.装备池引用[槽位名]) {
                let 引用池名 = 目标白名单配置.装备池引用[槽位名];
                护甲池来源提示 = `白名单定制池(${难度标识}.${引用池名})`;
                if (定制实体护甲池 && 定制实体护甲池[难度标识] && 定制实体护甲池[难度标识][引用池名]) {
                    当前护甲池数组 = 定制实体护甲池[难度标识][引用池名];
                }
            }
            if (!当前护甲池数组 && 目标直接修改配置 && 目标直接修改配置.装备池引用 && 目标直接修改配置.装备池引用[槽位名]) {
                let 引用池名 = 目标直接修改配置.装备池引用[槽位名];
                护甲池来源提示 = `不修饰符定制池(${难度标识}.${引用池名})`;
                if (定制实体护甲池 && 定制实体护甲池[难度标识] && 定制实体护甲池[难度标识][引用池名]) {
                    当前护甲池数组 = 定制实体护甲池[难度标识][引用池名];
                }
            }
            if (!当前护甲池数组 && 难度护甲池 && 难度护甲池[难度标识] && 难度护甲池[难度标识][槽位名]) {
                护甲池来源提示 = `难度护甲池(${难度标识}.${槽位名})`;
                当前护甲池数组 = 难度护甲池[难度标识][槽位名];
            }

            if (当前护甲池数组) {
                抽中护甲物品 = 从物品池取随机物品(当前护甲池数组, 护甲池来源提示);
            }

            if (抽中护甲物品) {
                let 实际装备护甲 = 抽中护甲物品.copy();
                实际装备护甲 = 实际装备护甲.enchant("minecraft:binding_curse", 1);
                实际装备护甲 = 实际装备护甲.enchant("l2hostility:vanish", 1);
                目标.setItemSlot(槽位枚举, 实际装备护甲);
                if (typeof 目标.setDropChance === "function") {
                    目标.setDropChance(槽位枚举, 0.0);
                }
                生物强化日志(`${目标ID} 的 ${槽位名} 已装备 ${实际装备护甲.id}`);
            }
        }
    }

    let 配置武器类型 = "无";
    if (目标直接修改配置 && 目标直接修改配置.武器类型) 配置武器类型 = 目标直接修改配置.武器类型;
    else if (目标定制配置 && 目标定制配置.武器类型) 配置武器类型 = 目标定制配置.武器类型;
    else if (目标白名单配置 && 目标白名单配置.武器类型) 配置武器类型 = 目标白名单配置.武器类型;
    生物强化日志(`实体设定武器类型: ${配置武器类型}`);

    let 武器概率倍率 = 1.0;
    if (目标直接修改配置 && typeof 目标直接修改配置.武器概率 === "number") 武器概率倍率 *= 目标直接修改配置.武器概率;
    else if (目标白名单配置 && typeof 目标白名单配置.武器概率 === "number") 武器概率倍率 *= 目标白名单配置.武器概率;

    if (目标定制配置 && 目标定制配置.装备池引用 && 目标定制配置.装备池引用.武器 &&
        !(目标定制配置.装备基础概率 && 目标定制配置.装备基础概率.武器 !== undefined) &&
        武器概率倍率 === 0) {
        武器概率倍率 = 1.0;
    }

    let 武器基础掉落率 = 当前装备基础概率表.武器 !== undefined ? 当前装备基础概率表.武器 : 0;
    let 武器最终掉落率 = 武器基础掉落率 * 武器概率倍率;
    生物强化日志(`武器 - 最终装备概率: ${武器最终掉落率}`);

    if (配置武器类型 !== "无" && 武器最终掉落率 > 0 && Math.random() < 武器最终掉落率) {
        let 抽中武器物品 = null;
        let 当前武器池数组 = null;
        let 武器池来源提示 = "";

        if (目标定制配置 && 目标定制配置.装备池引用 && 目标定制配置.装备池引用.武器) {
            let 引用池名 = 目标定制配置.装备池引用.武器;
            武器池来源提示 = `定制武器池(${难度标识}.${引用池名})`;
            if (定制实体武器池 && 定制实体武器池[难度标识] && 定制实体武器池[难度标识][引用池名]) {
                当前武器池数组 = 定制实体武器池[难度标识][引用池名];
            }
        }
        if (!当前武器池数组 && 目标白名单配置 && 目标白名单配置.装备池引用 && 目标白名单配置.装备池引用.武器) {
            let 引用池名 = 目标白名单配置.装备池引用.武器;
            武器池来源提示 = `白名单定制武器池(${难度标识}.${引用池名})`;
            if (定制实体武器池 && 定制实体武器池[难度标识] && 定制实体武器池[难度标识][引用池名]) {
                当前武器池数组 = 定制实体武器池[难度标识][引用池名];
            }
        }
        if (!当前武器池数组 && 目标直接修改配置 && 目标直接修改配置.装备池引用 && 目标直接修改配置.装备池引用.武器) {
            let 引用池名 = 目标直接修改配置.装备池引用.武器;
            武器池来源提示 = `不修饰符定制武器池(${难度标识}.${引用池名})`;
            if (定制实体武器池 && 定制实体武器池[难度标识] && 定制实体武器池[难度标识][引用池名]) {
                当前武器池数组 = 定制实体武器池[难度标识][引用池名];
            }
        }
        if (!当前武器池数组) {
            if (配置武器类型 === "远程" && 难度远程武器池 && 难度远程武器池[难度标识]) {
                武器池来源提示 = `难度远程武器池(${难度标识})`;
                当前武器池数组 = 难度远程武器池[难度标识];
            } else if (配置武器类型 === "近战" && 难度近战武器池 && 难度近战武器池[难度标识]) {
                武器池来源提示 = `难度近战武器池(${难度标识})`;
                当前武器池数组 = 难度近战武器池[难度标识];
            }
        }

        if (当前武器池数组) 抽中武器物品 = 从物品池取随机物品(当前武器池数组, 武器池来源提示);

        if (抽中武器物品) {
            let 实际装备武器 = 抽中武器物品.copy();
            实际装备武器 = 实际装备武器.enchant("minecraft:binding_curse", 1); // 绑定诅咒
            实际装备武器 = 实际装备武器.enchant("l2hostility:vanish", 1); // 毁灭
            目标.setMainHandItem(实际装备武器);
            if (typeof 目标.setDropChance === "function") 目标.setDropChance($装备槽类型.MAINHAND, 0.0);
            生物强化日志(`${目标ID} 已装备武器 ${实际装备武器.id}`);
        }
    }

    let 当前实体名称列表 = null;
    let 命名触发键 = null;

    if (目标直接修改配置) {
        if (目标直接修改配置.名字 && Array.isArray(目标直接修改配置.名字) && 目标直接修改配置.名字.length > 0) {
            当前实体名称列表 = 目标直接修改配置.名字;
            命名触发键 = "名字";
        } else if (目标直接修改配置.名称 && Array.isArray(目标直接修改配置.名称) && 目标直接修改配置.名称.length > 0) {
            当前实体名称列表 = 目标直接修改配置.名称;
            命名触发键 = "名称";
        }
    }

    if (!命名触发键 && 目标定制配置) {
        if (目标定制配置.名字 && Array.isArray(目标定制配置.名字) && 目标定制配置.名字.length > 0) {
            当前实体名称列表 = 目标定制配置.名字;
            命名触发键 = "名字";
        } else if (目标定制配置.名称 && Array.isArray(目标定制配置.名称) && 目标定制配置.名称.length > 0) {
            当前实体名称列表 = 目标定制配置.名称;
            命名触发键 = "名称";
        }
    }

    if (!命名触发键 && 目标白名单配置) {
        if (目标白名单配置.名字 && Array.isArray(目标白名单配置.名字) && 目标白名单配置.名字.length > 0) {
            当前实体名称列表 = 目标白名单配置.名字;
            命名触发键 = "名字";
        } else if (目标白名单配置.名称 && Array.isArray(目标白名单配置.名称) && 目标白名单配置.名称.length > 0) {
            当前实体名称列表 = 目标白名单配置.名称;
            命名触发键 = "名称";
        }
    }

    if (当前实体名称列表 && 当前实体名称列表.length > 0 && 命名触发键) {
        let 合法名称们 = 当前实体名称列表.filter(名 => typeof 名 === "string" && 名.trim() !== "");
        if (合法名称们.length > 0) {
            let 应该命名 = false;
            if (命名触发键 === "名字") {
                应该命名 = true;
                生物强化日志(`${目标ID} 因配置键 "${命名触发键}" 将直接尝试命名。`);
            } else if (命名触发键 === "名称") {
                let 头盔物品 = 目标.headArmorItem;
                let 胸甲物品 = 目标.chestArmorItem;
                let 护腿物品 = 目标.legsArmorItem;
                let 靴子物品 = 目标.feetArmorItem;
                let 主手物品 = 目标.mainHandItem;
                let 是否装备头盔 = 头盔物品 && !头盔物品.isEmpty();
                let 是否装备胸甲 = 胸甲物品 && !胸甲物品.isEmpty();
                let 是否装备护腿 = 护腿物品 && !护腿物品.isEmpty();
                let 是否装备靴子 = 靴子物品 && !靴子物品.isEmpty();
                let 是否装备武器 = 主手物品 && !主手物品.isEmpty();

                if (是否装备头盔 && 是否装备胸甲 && 是否装备护腿 && 是否装备靴子 && 是否装备武器) {
                    应该命名 = true;
                    生物强化日志(`${目标ID} 因配置键 "${命名触发键}" 且已全副武装，将尝试命名。`);
                } else {
                    生物强化日志(`${目标ID} 配置了 "${命名触发键}"，但未全副武装，不进行命名。`);
                }
            }

            if (应该命名) {
                let 随机索引 = Math.floor(Math.random() * 合法名称们.length);
                let 随机名称 = 合法名称们[随机索引];
                目标.setCustomName(Text.of(随机名称));
                目标.setCustomNameVisible(true);
                生物强化日志(`${目标ID} 已被成功命名为: "${随机名称}" (源于配置键: ${命名触发键})`);
            }
        } else {
            生物强化日志(`${目标ID} 配置的 ${命名触发键} 列表内所有名称条目均无效。`);
        }
    }
    目标.persistentData.putBoolean(已处理标记键, true);
});

let 阶段调试日志 = (参数) => {
    if (阶段赋予调试) {
        console.log("[阶段赋予调试]", 参数);
    }
};
let 阶段调试警告 = (参数) => {
    if (阶段赋予调试) {
        console.warn("[阶段赋予警告]", 参数);
    }
};

PlayerEvents.advancement(e => {
    阶段调试日志("PlayerEvents.advancement 事件触发");
    let p = e.player;
    let s = p.server;
    let pDATA = p.persistentData;
    let sDATA = s.persistentData;

    let 完成的进度ID = null;
    if (e.advancement && typeof e.advancement.id === 'function') {
        完成的进度ID = e.advancement.id().toString();
    } else if (e.advancement && e.advancement.id) {
        完成的进度ID = e.advancement.id.toString();
    } else {
        阶段调试警告("无法获取进度ID，跳过阶段赋予。");
        return;
    }
    阶段调试日志("玩家 ", p.name.string, " 完成进度: ", 完成的进度ID);

    let 全局动态难度启用状态键 = "globalDynamicDifficultyState";
    let 个人动态难度启用键 = "dynamicDifficultyEnabled";

    let 动态阶段赋予是否生效 = false;
    let 开关来源 = "未知";

    if (sDATA.contains(全局动态难度启用状态键)) {
        动态阶段赋予是否生效 = sDATA.getBoolean(全局动态难度启用状态键);
        开关来源 = "全局设置 (" + (动态阶段赋予是否生效 ? '开启' : '关闭') + ")";
        阶段调试日志("检测到全局动态难度设置: ", (动态阶段赋予是否生效 ? '开启' : '关闭'));
    } else {
        阶段调试日志("未检测到全局动态难度设置，检查个人设置。");
        if (pDATA.contains(个人动态难度启用键)) {
            动态阶段赋予是否生效 = pDATA.getBoolean(个人动态难度启用键);
            开关来源 = "个人设置 (" + (动态阶段赋予是否生效 ? '开启' : '关闭') + ")";
            阶段调试日志("检测到玩家 ", p.name.string, " 的个人动态难度设置: ", (动态阶段赋予是否生效 ? '开启' : '关闭'));
        } else {
            动态阶段赋予是否生效 = true;
            开关来源 = "默认值 (个人未设置，默认为 " + (动态阶段赋予是否生效 ? '开启' : '关闭') + ")";
            阶段调试日志("玩家 ", p.name.string, " 未设置个人动态难度，使用默认值: ", (动态阶段赋予是否生效 ? '开启' : '关闭'));
        }
    }
    阶段调试日志("最终动态阶段赋予开关状态 (", 开关来源, "): ", (动态阶段赋予是否生效 ? '生效' : '不生效'));

    if (!动态阶段赋予是否生效) {
        阶段调试日志("动态阶段赋予已关闭，不处理阶段变更。");
        return;
    }

    let 需赋予的阶段名 = 进度到阶段映射 ? 进度到阶段映射[完成的进度ID] : undefined;
    阶段调试日志("进度 ", 完成的进度ID, " 映射到阶段: ", (需赋予的阶段名 || '无'));

    if (需赋予的阶段名) {
        if (p.stages && typeof p.stages.has === 'function' && typeof p.stages.add === 'function') {
            let 优先级列表 = 动态阶段优先级;
            if (优先级列表 && Array.isArray(优先级列表)) {
                阶段调试日志("优先级列表:", JSON.stringify(优先级列表));
                let 玩家当前最高动态阶段索引 = -1;
                let 玩家当前最高阶段名 = "无";
                for (let i = 0; i < 优先级列表.length; i++) {
                    if (p.stages.has(优先级列表[i])) {
                        玩家当前最高动态阶段索引 = i;
                        玩家当前最高阶段名 = 优先级列表[i];
                        break;
                    }
                }
                阶段调试日志("玩家当前最高动态阶段: ", 玩家当前最高阶段名, " (索引: ", 玩家当前最高动态阶段索引, ")");

                let 需赋予阶段索引 = 优先级列表.indexOf(需赋予的阶段名);
                阶段调试日志("需赋予阶段 ", 需赋予的阶段名, " 的索引: ", 需赋予阶段索引);

                if (需赋予阶段索引 !== -1 && (玩家当前最高动态阶段索引 === -1 || 需赋予阶段索引 < 玩家当前最高动态阶段索引)) {
                    阶段调试日志("条件满足：新阶段有效且优先级更高（或玩家尚无阶段）。准备更新阶段。");
                    优先级列表.forEach(旧阶段名 => {
                        if (旧阶段名 !== 需赋予的阶段名 && p.stages.has(旧阶段名)) {
                            阶段调试日志("移除旧阶段: ", 旧阶段名);
                            p.stages.remove(旧阶段名);
                        }
                    });

                    if (!p.stages.has(需赋予的阶段名)) {
                        阶段调试日志("添加新阶段: ", 需赋予的阶段名);
                        p.stages.add(需赋予的阶段名);
                        let 显示名 = 需赋予的阶段名.startsWith("LV") ? "等级 " + 需赋予的阶段名.substring(2) : 需赋予的阶段名;
                        p.tell(Text.of("你已进入新的动态强化阶段: " + 显示名).color("light_purple").bold());
                    } else {
                        阶段调试日志("玩家已拥有阶段 ", 需赋予的阶段名, "，无需重复添加。");
                    }
                } else {
                    阶段调试日志("条件不满足：新阶段无效，或优先级不高于当前阶段，或与当前阶段相同。不更新阶段。");
                }
            } else {
                阶段调试警告("动态阶段优先级列表, 未定义或不是数组。");
            }
        } else {
            阶段调试警告("玩家 ", p.name.string, " 的 stages 对象无效或缺少 has/add 方法。");
        }
    } else {
        阶段调试日志("进度 ", 完成的进度ID, " 没有映射到任何动态强化阶段。");
    }
    阶段调试日志("PlayerEvents.advancement 事件处理完毕 for ", 完成的进度ID);
});